<?php 



/*-----------------------------------------------------------------------------------*/
/*	get image uploaded full url in visual composer
/*-----------------------------------------------------------------------------------*/ 


/**  Shortcodes | Image compatibility.
--------------------------------------------------------------------------------------------------- */

function peace_vc_image( $image = false ){
	if( $image && is_numeric( $image ) ){
		$image = wp_get_attachment_image_src( $image, 'full' );
		$image = $image[0];
	}
	return $image;
};


/*------------------------------------------------------------------------------------------------------------------*/
/*	genaral shortcode 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode( 'peach_title_shortcode', 'peach_title_shortcode_special' );

function peach_title_shortcode_special($atts, $content = null) {
	extract( shortcode_atts(
		array(
			'title'			=> '',
			'description'		=> '',
			), $atts )
	);
	ob_start();
	?>

	<h2 class="section-title <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.4s"><?php echo esc_html($title); ?></h2><!-- /.section-title -->
	<?php if(!empty($description)) { ?>
	<div class="section-detail <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s"><?php echo wp_kses_post($description); ?></div><!-- /.section-detail -->
	<?php } ?>
	<?php
	return ob_get_clean();
}

/*------------------------------------------------------------------------------------------------------------------*/
/*	peace - muslim- piler of islam 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode( 'piler_of_islam', 'peace_muslim_piler' );

function peace_muslim_piler($atts, $content = null) {
	extract( shortcode_atts(
		array(
			'title'			=> '',
			'description'	=> '',
			'flat_icon'		=> '',
			'flat_icon2'	=> '',
			'flat_icon3'	=> '',
			'flat_icon4'	=> '',
			'flat_icon5'	=> '',
			'element_title'	=> '',
			'element_title2'=> '',
			'element_title3'=> '',
			'element_title4'=> '',
			'element_title5'=> '',
			'icon'			=> '',
			'icon2'			=> '',
			'icon3'			=> '',
			'icon4'			=> '',
			'icon5'			=> '',
			'icon_fontawesome' => '',
			'icon_openiconic'=> '',
			'icon_entypo'	=> '',
			'icon_linecons'	=> '',
			'icon_fontawesome2' => '',
			'icon_openiconic2'=> '',
			'icon_entypo2'	=> '',
			'icon_linecons2'	=> '',
			'icon_fontawesome3' => '',
			'icon_openiconic3'=> '',
			'icon_entypo3'	=> '',
			'icon_linecons3'	=> '',
			'icon_fontawesome4' => '',
			'icon_openiconic4'=> '',
			'icon_entypo4'	=> '',
			'icon_linecons4'	=> '',
			'icon_fontawesome5' => '',
			'icon_openiconic5'=> '',
			'icon_entypo5'	=> '',
			'icon_linecons5'	=> '',
			), $atts )
	);
ob_start();

?>
<section class="piller-of-islam section-padding">
	<div class="container">
		<div class="row">

			<h2 class="section-title <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.2s"><?php echo esc_html($title); ?></h2><!-- /.section-title -->
			<div class="section-detail <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.4s"><?php echo wp_kses_post($description); ?></div><!-- /.section-detail -->


			<div class="col-md-10 centered">
				<div class="piler-of-islam">
					<div class="col-5">
						<div class="item <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.5s">
							<div class="item-element">

								<span class="<?php if($flat_icon) { echo 'flaticon-'. esc_attr($flat_icon); } else {echo esc_attr($icon);} ?><?php 
									$types = '';
									$types =array('fontawesome', 'openiconic', 'entypo', 'linecons');
									foreach ($types as $type) {
										$iconClass = ${"icon_" . $type};
										echo esc_attr($iconClass);
									} ?>
									">
								</span>
								<div class="text">
									<?php echo esc_html($element_title); ?>
								</div>
							</div>
						</div>
					</div><!-- /.col-md-3 -->
					<div class="col-5">
						<div class="item <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
							<div class="item-element">
								<span class="<?php if($flat_icon2) { echo 'flaticon-'. esc_attr($flat_icon2); } else {echo esc_attr($icon2);} ?><?php 
									$types2 = '';
									$types2 =array('fontawesome2', 'openiconic2', 'entypo2', 'linecons2');

									foreach ($types2 as $type2) {
										$iconClass2 = ${"icon_" . $type2};
										echo esc_attr($iconClass2);
									} ?>
									
									"></span>
									<div class="text">
										<?php echo esc_html($element_title2); ?>
									</div>
								</div>
							</div>
						</div><!-- /.col-md-3 -->
						<div class="col-5">
							<div class="item <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.7s">
								<div class="item-element">
									<span class="<?php if($flat_icon3) { echo 'flaticon-'. esc_attr($flat_icon3); } else {echo esc_attr($icon3);} ?><?php 
										$types3 = '';
										$types3 =array('fontawesome3', 'openiconic3', 'entypo3', 'linecons3');

										foreach ($types3 as $type3) {
											$iconClass3 = ${"icon_" . $type3};
											echo esc_attr($iconClass3);
										} ?>

										">
									</span>
									<div class="text">
										<?php echo esc_html($element_title3); ?>
									</div>
								</div>
							</div>
						</div><!-- /.col-md-3 -->
						<div class="col-5">
							<div class="item <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
								<div class="item-element">
									<span class="<?php if($flat_icon4) { echo 'flaticon-'. esc_attr($flat_icon4); } else {echo esc_attr($icon4);} ?><?php 
										$types4 = '';
										$types4 =array('fontawesome4', 'openiconic4', 'entypo4', 'linecons4');

										foreach ($types4 as $type4) {
											$iconClass4 = ${"icon_" . $type4};
											echo esc_attr($iconClass4);
										} ?>

										"></span>
										<div class="text">
											<?php echo esc_html($element_title4); ?>
										</div>
									</div>
								</div>
							</div><!-- /.col-md-3 -->
							<div class="col-5">
								<div class="item <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.9s">
									<div class="item-element">
										<span class="<?php if($flat_icon5) { echo 'flaticon-'. esc_attr($flat_icon5); } else {echo esc_attr($icon5);} ?><?php 
											$types5 = '';
											$types5 =array('fontawesome5', 'openiconic5', 'entypo5', 'linecons5');

											foreach ($types5 as $type5) {
												$iconClass5 = ${"icon_" . $type5};
												echo esc_attr($iconClass5);
											} ?>

											">
										</span>
										<div class="text">
											<?php echo esc_html($element_title5); ?>
										</div>
									</div>
								</div>
							</div><!-- /.col-md-3 -->
						</div>


					</div>

				</div><!-- /.row -->
				<div class="curve-line hidden-xs"></div>
			</div><!-- /.container -->
		</section><!-- /#piller-of-islam -->
		<?php
		return ob_get_clean();
	}


/**  feature item (muslim).
--------------------------------------------------------------------------------------------------- */
add_shortcode( 'piler_of_islam_sub', 'peace_muslim_piler_inner' );

function peace_muslim_piler_inner($atts, $content=null) {
	extract( shortcode_atts(
		array(
			'icon_fontawesome'				=> '',
			'icon_openiconic'	=> '',
			'icon_entypo'	=> '',
			'icon_linecons'	=> '',
			'icon_type_feature_muslim'			=> '',
			'element_title'		=> '',
			), $atts )
	);
	$types = '';
	$types =array('fontawesome', 'openiconic', 'entypo', 'linecons', 'type_feature_muslim');
	
	ob_start();
	?>
	<div class="piler-of-islam">
		<div class="col-5">
			<div class="item">
				<div class="item-element">
					<span class="<?php 
					foreach ($types as $type) {
						$iconClass = isset( ${"icon_" . $type} ) ? esc_attr( ${"icon_" . $type} ) : 'fa fa-adjust';
						echo esc_attr($iconClass);
					} ?>"></span>
					<div class="text">
						<?php echo $element_title ?>
					</div>
				</div>
			</div>
		</div><!-- /.col-md-3 -->
	</div>
	<?php
	return ob_get_clean();
}


/*------------------------------------------------------------------------------------------------------------------*/
/*	peace sermons 
/*------------------------------------------------------------------------------------------------------------------*/ 
add_shortcode('peace_sermons', 'peace_sermons_shortcode' );

function peace_sermons_shortcode($atts, $content = null) {

	extract( shortcode_atts(
		array(
			'post_no'				=> '',
			), $atts )
	);
	ob_start(); ?>
	<div class="sermons">
		<?php 
		query_posts('post_type=sermons&posts_per_page=' .$post_no  );
		if(have_posts()) : while(have_posts()) : the_post(); 
		$sermons_data = get_post_meta( get_the_ID(), '_sermons_page_options', true );
		?> 
		<div class="col-md-6 col-sm-6">
			<div class="portal <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
				<?php the_post_thumbnail('thumbnail' ); ?>
				<div class="content"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
				<div class="post-date">
					<?php _e('Post By', 'peace') ?> <?php the_author_link(); ?> | <?php _e('Post On', 'peace') ?> <?php the_time('d M Y' ); ?>
				</div>
				<div class="resource">
					<?php if(!empty($sermons_data['video'])) { ?>
					<a href="<?php echo esc_attr( $sermons_data['video'] ); ?>"><i class="fa fa-video-camera"></i></a>
					<?php } ?>
					<?php if(!empty($sermons_data['audio'])) { ?>
					<a href="<?php echo esc_attr( $sermons_data['audio'] ); ?>"><i class="fa fa-headphones"></i></a>
					<?php } ?>
					<?php if(!empty($sermons_data['doc_file'])) { ?>
					<a href="<?php echo esc_attr( $sermons_data['doc_file'] ); ?>"><i class="fa fa-file-text-o"></i></a>
					<?php } ?>
					<?php if(!empty($sermons_data['pdf_file'])) { ?>
					<a href="<?php echo esc_attr( $sermons_data['pdf_file'] ); ?>"><i class="fa fa-file-image-o"></i></a>
					<?php } ?>
				</div>
			</div>
		</div>
	<?php endwhile;endif; wp_reset_query(); ?>

</div>
<?php
return ob_get_clean();
}


/*------------------------------------------------------------------------------------------------------------------*/
/*	peace event 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode( 'recent_event', 'recent_event_shortcode' );


function recent_event_shortcode($atts, $content = null ) {

	extract( shortcode_atts(
		array(
			'post_no' 		=> '',
			'event_post_excerpt' => '',
			), $atts )
	);
	ob_start();
	
	?>
	<?php query_posts('post_type=events&posts_per_page=' .$post_no ); ?>
	<?php if(have_posts()) : while(have_posts()) : the_post(); 
	$event_data = get_post_meta( get_the_ID(), '_events_page_options', true );

	?> 
	<div class="col-md-4">
		<div class="all-event <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
			<div class="event-post">
					<?php if(has_post_thumbnail()) { ?>
					<div class="feature-img">
						<?php the_post_thumbnail('medium'); ?>
					</div>
					<?php } ?>

					<?php if(!empty($event_data['event_date'])) { 
					$str = $event_data['event_date'];
					$splt = explode(' ', $str);
					?>
					<div class="events-date">
						<span class="event-date"><?php echo esc_html($splt[0]); ?></span><br>

						<span class="event-month"><?php $month = $splt[1]; echo $month; ?></span>
					</div>
					<?php } ?>

					<h2 class="uppercase"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
					<div class="event-period">
						<div class="row">
							<p class="col-md-10 period-session">
								<i class="fa fa-clock-o"></i> <?php echo esc_html( $event_data['event_duration']); ?> <br>
								<i class="fa fa-map-marker"></i> <?php echo esc_html( $event_data['event_location'] ); ?>
							</p>
							<p class="col-md-2 comments-share">
								<i class="fa fa-share-alt">
									<span class="social-button">
										<a href="http://www.facebook.com/sharer.php?u=<?php echo str_replace( '-', '%20', get_the_permalink()); ?>&amp;t=<?php echo str_replace( ' ', '%20', get_the_title()); ?>" title="Share this post on Facebook!" onclick="window.open(this.href); return false;"><i class="fa fa-facebook"></i></a>
										<a href="http://twitter.com/home?status=<?php echo str_replace( '-', '%20', get_the_permalink()); ?>" title="Share this post on Twitter!" target="_blank"><i class="fa fa-twitter"></i></a>
										<a href="https://plus.google.com/share?url=<?php echo str_replace( '-', '%20', get_the_permalink()); ?>" title="Share this post on google plus!" target="_blank"><i class="fa fa-google-plus"></i></a>
										<a class="linkedin" href="http://www.linkedin.com/shareArticle?mini=true&amp;title=<?php echo str_replace( ' ', '%20', get_the_title()); ?>&amp;url=<?php echo str_replace( '-', '%20', get_the_permalink()); ?>" title="Share on LinkedIn" rel="external nofollow" target="_blank"><i class="fa fa-linkedin"></i></a>
										<a class="pinterest" href="http://pinterest.com/pin/create/button/?url=<?php echo str_replace( '-', '%20', get_the_permalink()); ?>" title="Pinterest" rel="nofollow" target="_blank"><i class="fa fa-pinterest"></i></a>
									</span>
								</i>

							</p><!-- /.comments-share -->
						</div>
					</div><!-- /.event-period -->

					<div class="event-description">
						<?php 
						if(!empty($event_post_excerpt)) {
							echo substr(get_the_excerpt(), 0,$event_post_excerpt); 
						} else {
							the_excerpt();
						}
						?>
					</div>
				</div>
			</div>
		</div>
	<?php endwhile;endif; wp_reset_query(); ?>

	<?php
	return ob_get_clean();
}


/**  gallery shortcode.
--------------------------------------------------------------------------------------------------- */

add_shortcode( 'peace_gallery', 'peace_gallery_shorcode_special' );

function peace_gallery_shorcode_special($atts, $content = null) {
	extract( shortcode_atts(
		array(
			'post_no'      		=> '',
			'category_slug'     => '',
			'column_no'			=> '',
			'more_link'			=> '',
			'spacing_on_off'	=> '',
			), $atts )
	);
	ob_start();
	?>


	<div class="portfolio gallery-section <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
		<div class="container">

			<div  class="isotope-filters portfolio-filter">

				<button class="button is-checked" data-sort-by="original-order">ALL</button>
				<?php

				$strings="$category_slug";
				$str = str_replace(',', '', $strings);
				$array=explode(" ",$str);
				$args = array(
					'slug'           => $array, 
					); 
				if(!empty($category_slug)) {
					$filters = get_terms( 'image-category', $args );
				} else {
					$filters = get_terms( 'image-category');
				}
				foreach ($filters as $filter) {
					echo "<button data-filter=\".$filter->slug\">$filter->name</button>";
				}
				?>

				<?php 
				if(!empty($category_slug)) {
					global $post;
					$paged = get_query_var('paged') ? get_query_var('paged') : 1;
					$args = array(
						'post_type' => 'gallery',
						'posts_per_page' => esc_attr($post_no),
						'paged' => get_query_var('paged'),
						'tax_query' => array(
							array(
								'taxonomy' => 'image-category',
								'field' => 'slug',
								'terms' => $array,
								)
							)
						);
					$query = new WP_Query( $args );
				} else {
					global $post;
					$args = array(
						'post_type' => 'gallery',
						'posts_per_page' => esc_attr($post_no),
						'paged' => get_query_var('paged'),
						'taxonomy' => 'image-category',

						);
					$query = new WP_Query( $args );
				}
				?>
			</div>
		</div>
		<div class="clearfix portfolio-item isotope-items isotope-masonry-items">
			<?php 
			if($query->have_posts()) : while($query->have_posts()) : $query->the_post(); 

			$terms = wp_get_post_terms(get_the_ID(), 'image-category' ); 
			$url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) );


			$t = array();       
			foreach($terms as $term) 
				$t[] = $term->slug;


			$image_attributes = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); 
			
			?> 
			<div class="item <?php echo implode(' ', $t); ?> effect-oscar">
				<?php if ( has_post_thumbnail() ) { 
					the_post_thumbnail('gallery-thumb'); 
				} else {
					echo '<img src="'.get_template_directory_uri().'/assets/images/no-img.jpg">';
				}
				?>

				<div class="item-description">
					<div class="item-link">
						<a class="boxer" data-boxer-height="500" data-boxer-width="500" href="<?php echo esc_url( $url ); ?>">
							<i class="fa plus-sign"></i>
						</a>
					</div><!-- /.item-link -->
					
				</div>
			</div>
			<?php 
			endwhile;endif;

                              //reset
			wp_reset_query();

			?>
		</div><!-- /.gallery-item -->

		<a class="read-more" href="<?php echo esc_url($more_link ); ?>"><?php _e('View More', 'peace') ?></a>
		<div class="clearfix"></div>
	</div><!-- /.gallery-section -->


	<script>

/*------------------------------------------------------------------------------------------------------------------*/
/*   isotop.   
/*------------------------------------------------------------------------------------------------------------------*/ 



/*-------------------------- Isotope Init --------------------*/
jQuery(window).on("load resize",function(e){

	var $container = jQuery('.isotope-items'),
	colWidth = function () {
		var w = $container.width(), 
		columnNum = 1,
		columnWidth = 0;
		if (w > 1040)     { columnNum  = <?php echo esc_attr($column_no); ?>; }  
		else if (w > 850) { columnNum  = 2; }  
		else if (w > 768) { columnNum  = 2; }  
		else if (w > 480) { columnNum  = 2; }
		columnWidth = Math.floor(w/columnNum);

      //Isotop Version 1
      var $containerV1 = jQuery('.isotope-items');
      $containerV1.find('.item').each(function() {
      	var $item = jQuery(this),
      	multiplier_w = $item.attr('class').match(/item-w(\d)/),
      	multiplier_h = $item.attr('class').match(/item-h(\d)/),
      	width = multiplier_w ? columnWidth*multiplier_w[1]-10 : <?php if($spacing_on_off) { echo "columnWidth-20";} else {echo "columnWidth";} ?>,
      	height = multiplier_h ? columnWidth*multiplier_h[1]*0.7: columnWidth*0.7;
      	$item.css({ width: width, height: height, <?php if($spacing_on_off) { echo "marginTop: '20px', marginLeft: '10px', marginRight: '10px'"; } ?>  });
      });


      return columnWidth;
  },
  isotope = function () {
  	$container.isotope({
  		resizable: true,
  		itemSelector: '.item',
  		masonry: {
  			columnWidth: colWidth(),
  			gutterWidth: 10
  		}
  	});
  };
  isotope();



   // bind filter button click
   jQuery('.isotope-filters').on( 'click', 'button', function() {
   	var filterValue = jQuery( this ).attr('data-filter');
   	$container.isotope({ filter: filterValue });
   });

// change active class on buttons
jQuery('.isotope-filters').each( function( i, buttonGroup ) {
	var $buttonGroup = jQuery( buttonGroup );
	$buttonGroup.on( 'click', 'button', function() {
		$buttonGroup.find('.active').removeClass('active');
		jQuery( this ).addClass('active');
	});
});


// Masonry Isotope
var $masonryIsotope = jQuery('.isotope-masonry-items').isotope({
	itemSelector: '.item',
});

// bind filter button click
jQuery('.isotope-filters').on( 'click', 'button', function() {
	var filterValue = jQuery( this ).attr('data-filter');
	$masonryIsotope.isotope({ filter: filterValue });
});

// change active class on buttons
jQuery('.isotope-filters').each( function( i, buttonGroup ) {
	var $buttonGroup = jQuery( buttonGroup );
	$buttonGroup.on( 'click', 'button', function() {
		$buttonGroup.find('.active').removeClass('active');
		jQuery( this ).addClass('active');
	});
});
});
</script>

<?php
return ob_get_clean();
}

/*------------------------------------------------------------------------------------------------------------------*/
/*	urgent causes 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_urgent_causes', 'peace_urgent_causes_shortcode' );

function peace_urgent_causes_shortcode($atts, $content = null) {
	extract( shortcode_atts(
		array(
			'image'       	=> '',
			'title'			=>'',
			'goal'       	=> '',
			'donate'		=> '',
			'doner'			=>'',
			'daysleft'		=> '',
			'donation_link'	=> '',
			), $atts )
	);
	ob_start();

	$image = peace_vc_image($image);
	$percent = ($donate*100)/$goal;
	?>

	<section class="donate section-padding" style="position: relative; z-index: 1; background: url(<?php echo esc_url($image) ?>) top center;">
		<div class="container">
			<div class="row">
				<h2 class="section-title <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.3s"><?php echo esc_html($title ); ?></h2><!-- /.section-title -->

				<div class="donate-details">

					<div class="goal <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.5s">
						<div class="content">
							<h3><?php echo esc_html($percent ); ?>%</h3>
							<span><?php _e('Founded', 'peace') ?></span>
						</div>
					</div>
					<div class="goal <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.6s">
						<div class="content">
							<h3>$ <?php echo esc_html($donate ); ?></h3>
							<span><?php _e('Donate', 'peace') ?></span>
						</div>
					</div>
					<div class="goal <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.7s">
						<div class="content">
							<h3>$ <?php echo esc_html($goal ); ?></h3>
							<span><?php _e('Goal', 'peace') ?></span>
						</div>
					</div>
					<div class="goal <?php echo wow_effect(); ?> fadeInRight" data-wow-delay="0.6s">
						<div class="content">
							<h3><?php echo esc_html($doner ); ?></h3>
							<span><?php _e('Donator', 'peace') ?></span>
						</div>
					</div>
					<div class="goal <?php echo wow_effect(); ?> fadeInRight" data-wow-delay="0.9s">
						<div class="content">
							<h3><?php echo esc_html($daysleft ); ?></h3>
							<span><?php _e('Day to go', 'peace') ?></span>
						</div>
					</div>
				</div>

				<div class="found <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s"><?php echo esc_html($percent); ?> % Founded <span> / $ 62,000 To Go</span></div>
				<div class="page-wrap centered <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
					<div class="meter red">
						<span style="width: <?php echo esc_html($percent); ?>%"></span>
					</div>
				</div><br>
				<p class="event-btn-container col-md-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.4s">
					<a class="btn custom-btn" href="<?php echo esc_html($donation_link ); ?>"><?php _e('DONATE NOW', 'peace') ?> <i class="fa fa-heart"></i></a>
				</p>

			</div><!-- /.row -->
		</div><!-- /.container -->
	</section>



	<?php

	return ob_get_clean();
}

/*------------------------------------------------------------------------------------------------------------------*/
/*	client  
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_client', 'peace_client_shortcode' );

function peace_client_shortcode($atts, $content = null) {
	extract( shortcode_atts(
		array(
			'image'       	=> '',
			'link'			=>'',
			), $atts )
	);
	ob_start();
	$image = peace_vc_image($image);
	?>
	<div class="client <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
		<a href="<?php echo esc_url($link) ?>"><img src="<?php echo esc_url($image) ?>" alt="<?php echo esc_url($link) ?>"></a>
	</div>
	<?php
	return ob_get_clean();
}


/*------------------------------------------------------------------------------------------------------------------*/
/*	google map 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_map', 'peace_google_map' );	

function peace_google_map($atts, $content = null) {

	extract( shortcode_atts(
		array(
			'latitude'      => '',
			'longitude'     => '',
			'icon'			=> '',
			'image'			=> '',
			'name'       	=> '',
			'designation'   => '',
			'phone'       	=> '',
			'email'       	=> '',
			'address'		=> '',
			'time'			=> '',
			), $atts )
	);
	ob_start();
	?>

	<div class="map-container <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.4s">
		<div class="googleMaps google-map-container"></div>
		<div class="contact-info col-md-6 pull-right <?php echo wow_effect(); ?> fadeInRight" data-wow-delay="0.6s">
			<div class="contact-person">
				<h2><?php _e('Contact Person', 'peace') ?></h2>
				<img width="150" height="150" src="<?php echo esc_attr($image); ?>" class="img-circle" alt="team-3">
				<div class="info">
					<h3><?php echo esc_html($name) ?></h3>
					<p><?php echo esc_html($designation) ?> </p>
					<span><b><?php _e('TEL:', 'peace') ?></b> <?php echo esc_html($phone) ?></span><br>
					<span><b><?php _e('Email:', 'peace') ?></b> <?php echo esc_html($email) ?></span>
				</div><!-- /.info -->
			</div><!-- /.contact-person -->

			<div class="contact-information">
				<h2><?php _e('Contact Info', 'peace') ?></h2>
				<div class="address">
					<div class="media">
						<div class="media-left"><i class="fa fa-map-marker base-color"></i></div> <div class="media-body"><?php echo wp_kses_post($address) ?><br></div> 
					</div>
					<div class="media">
						<div class="media-left"><i class="fa fa-clock-o base-color"></i></div> <div class="media-body"><?php echo wp_kses_post($time) ?></div>
					</div>
				</div><!-- /.info -->
			</div><!-- /.contact-person -->
		</div>
	</div>
	<!-- Google Map Section End -->	
	<script type="text/javascript">

		jQuery(document).ready(function() {
			var teamID = jQuery(".googleMaps");
			if(teamID.length) {
				/*----------- Google Map - with support of gmaps.js ----------------*/
				function isMobile() { 
					return ('ontouchstart' in document.documentElement);
				}

				function init_gmap() {
					if ( typeof google == 'undefined' ) return;
					var options = {
						center: [<?php echo esc_html($latitude) ?>, <?php echo esc_html($longitude) ?>],
						zoom: 15,
						mapTypeControl: true,
						mapTypeControlOptions: {
							style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
						},
						navigationControl: true,
						scrollwheel: false,
						streetViewControl: true
					}

					if (isMobile()) {
						options.draggable = false;
					}

					jQuery('.googleMaps').gmap3({
						map: {
							options: options
						},
						marker: {
							latLng: [<?php echo esc_html($latitude) ?>, <?php echo esc_html($longitude) ?>],
							options: { icon: "<?php echo esc_attr($icon); ?>" }
						}
					});
				}

				init_gmap();
			}

		});

</script>
<?php

return ob_get_clean();
}


/*------------------------------------------------------------------------------------------------------------------*/
/*	peace blog 
/*------------------------------------------------------------------------------------------------------------------*/ 


add_shortcode( 'peace_blog', 'peace_blog_style_shortcode' );

function peace_blog_style_shortcode($atts, $content = null ) {

	extract( shortcode_atts(
		array(
			'post_excerpt'			=> '',
			'category_name'			=> '',
			), $atts )
	);
	global $post;
	ob_start();
	?>
	<div class="peace-blog <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.5s">
		<div class="post-list-container">
			<div class="scrollbar-inner">
				<?php
				query_posts('post_type=post&category_name=' .$category_name );
				while ( have_posts() ) : the_post(); ?>
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

					<div class="post-list-block clearfix">
						<div class="post-img col-md-4">
							<div class="row">
								<?php if(has_post_thumbnail()) { ?>
								<a class="news-link" href="<?php the_permalink(); ?>">
									<?php the_post_thumbnail('post_img'); ?>
								</a>
								<?php } ?>
							</div>
						</div>
						<div class="post-info-block col-md-8">
							<h2><a class="uppercase" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
							<div class="news-info">
								<?php if ( 'post' == get_post_type() ) : ?>	

									<span class="news-author">
										<span class="tm"><i class="fa fa-calendar-o"></i> <?php the_time('d M Y' ); ?></span>  | <span class="usr"><i class="fa fa-user"></i> <?php the_author_link(); ?></span> | <span class="cmnt"><i class="fa fa-comments-o"></i> <?php comments_popup_link( '0', '1', '%'); ?></span>
									</span>
								<?php endif; ?>
							</div>

							<div class="info-text ">
								<?php 
								if(!empty($post_excerpt)) {
									echo substr(get_the_excerpt(), 0,$post_excerpt); 
								} else {
									the_excerpt();
								}
								?>
							</div>
						</div>
					</div>

				</article>
			<?php endwhile; wp_reset_query(); ?>	
		</div>
	</div>
</div>
<?php
return ob_get_clean();

}

/*------------------------------------------------------------------------------------------------------------------*/
/*	upcomming event 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_event_counter', 'peace_event_counter_shortcode' );

function peace_event_counter_shortcode($atts, $content = null) {
	extract( shortcode_atts(
		array(
			'title'			=> '',
			'time'			=> '',
			'link'			=> '',
			), $atts )
	);
	ob_start();
	?>
	<section class="event">
		<div class="next-event section-padding">
			<div class="container">	

				<h2 class="section-title col-md-3 <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.5s"><?php echo esc_html($title) ?></h2><!-- /.section-title -->
				<div class="row">
					<div class="event_time_countdown next-event-container">
						<div class="col-md-6 centered">
							<div class="row">
								<div class="col-sm-3 col-xs-6">
									<div class="clock_days <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
										<div class="bgLayer">
											<div class="topLayer"></div>
											<canvas class="canvas_days" width="110" height="110">
											</canvas>
											<div class="text">
												<p class="val">0</p>
												<p class="time_text">Days</p>
											</div>
										</div>
									</div><!-- Days -->
								</div>
								<div class="col-sm-3 col-xs-6">
									<div class="clock_hours <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
										<div class="bgLayer">
											<div class="topLayer"></div>
											<canvas class="canvas_hours" width="110" height="110">
											</canvas>
											<div class="text">
												<p class="val">0</p>
												<p class="time_text">Hours</p>
											</div>
										</div>
									</div><!-- Hours -->
								</div>
								<div class="col-sm-3 col-xs-6">
									<div class="clock_minutes <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="1s">
										<div class="bgLayer">
											<div class="topLayer"></div>
											<canvas class="canvas_minutes" width="110" height="110">
											</canvas>
											<div class="text">
												<p class="val">0</p>
												<p class="time_text">Minutes</p>
											</div>
										</div>
									</div>
								</div>
								<div class="col-sm-3 col-xs-6">
									<div class="clock_seconds <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="1.2s">
										<div class="bgLayer">
											<div class="topLayer"></div>
											<canvas class="canvas_seconds" width="110" height="110">
											</canvas>
											<div class="text">
												<p class="val">0</p>
												<p class="time_text">Seconds</p>
											</div>
										</div>
									</div>
								</div>
							</div><!-- /.row -->
						</div> <!-- /.event_time_countdown-->

					</div><!-- /.next-event-container -->
					<p class="event-btn-container col-md-2 <?php echo wow_effect(); ?> fadeInRight" data-wow-delay="1.4s">
						<a class="btn custom-btn" href="<?php echo esc_url($link); ?>"><?php esc_html_e( 'ALL EVENTS', 'peace' ); ?></a>
					</p>


				</div><!-- /.row -->
			</div><!-- /.container -->

		</div><!-- /.next-event -->

	</section>

	<?php
	$timestamp = strtotime("$time");
	
	function couter_barcolor() {
		$theme_color = cs_get_customize_option('theme_color_picker');
		if(!empty($theme_color)) {
			echo $theme_color;
		}else {
			echo "#f1c152";
		}
	}
	?>
	<script>
/**  circular countdown.
--------------------------------------------------------------------------------------------------- */
var findClass = jQuery('.next-event');

if(findClass.length) {

	jQuery(document).ready(function(){
		JBCountDown({
			secondsColor : "<?php echo couter_barcolor(); ?>",
			secondsGlow  : "none",

			minutesColor : "<?php echo couter_barcolor(); ?>",
			minutesGlow  : "none",

			hoursColor   : "<?php echo couter_barcolor(); ?>",
			hoursGlow    : "none",

			daysColor    : "<?php echo couter_barcolor(); ?>",
			daysGlow     : "none",

        // startDate   : "1443657600",
        endDate     : "<?php echo $timestamp; ?>",
        now         : "<?php echo time(); ?>"
    });
	});

}
</script>
<?php 

return ob_get_clean();

}

/*------------------------------------------------------------------------------------------------------------------*/
/*	quote 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_quote', 'peace_quote_shortcode' );

function peace_quote_shortcode($atts, $content = null) { 
	extract( shortcode_atts(
		array(
			'image'		=> '',
			'quote_from'	=>'',
			'quote_type'	=>'',
			'who_say'			=> '',
			'quote'			=> '',
			'book'=>'',
			'ref'=>'',
			), $atts )
	);
	ob_start();
	
	?>
	<section class="quotes section-padding" style="background-image: url(<?php echo esc_url($image ); ?>)">
		<div class="container">
			<div class="col-md-11 centered">

				<div class="prophet <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.6s">
					<div class="border-svg">
						<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
						viewBox="0 0 223 257" style="enable-background:new 0 0 223 257;" xml:space="preserve">
						<style type="text/css">
							.st0{fill:none;stroke:#f1c152;stroke-width:2;stroke-miterlimit:10;}
						</style>
							<g>
								<path class="st0" d="M221.9,170.7c0.4,12.1-8.1,26.6-18.8,32.3l-17,9c-10.7,5.7-27.8,15.6-38.1,22l-18,11.3
								c-10.3,6.4-27.1,6.4-37.3,0L77.9,236c-10.3-6.4-27.4-16.3-38.1-22l-20.3-10.9c-10.7-5.7-18.9-20.3-18.4-32.4L2.2,151
								c0.6-12.1,0.6-31.9,0-44l-1-20.8C0.7,74.2,9,59.7,19.7,54.1l16.7-8.7c10.7-5.6,27.9-15.5,38.1-21.9l18.3-11.6
								C103,5.4,120,5,130.4,11.1l73.1,42.2c10.5,6,18.7,20.9,18.4,33l-0.6,19.1c-0.4,12.1-0.4,31.9,0,44L221.9,170.7z"/>
							</g>
						</svg>
					</div>

				<div class="svg-fill">
					<img src="<?php echo get_template_directory_uri() . '/assets/hexa_fill_color.svg' ?>" alt="">
				</div>

				<div class="content">
					<span><?php echo esc_html($quote_from) ?></span>
					<h3><?php echo esc_html($quote_type) ?></h3>
				</div>
			</div>
			<div class="ref col-md-8 <?php echo wow_effect(); ?> fadeInRight" data-wow-delay="0.6s">
				<p><strong><?php echo esc_html($who_say) ?>: </strong>  <i>"<?php echo esc_html($quote) ?>"</i></p>
				<div class="ref-location"><?php echo esc_html($book) ?>, <small> <?php echo esc_html($ref) ?></small></div>
			</div>

		</div><!-- /.row -->
	</div><!-- /.container -->
</section>
<?php 

return ob_get_clean();
}

/*------------------------------------------------------------------------------------------------------------------*/
/*	prayer shedule 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_prayer_schedule', 'peace_prayer_schedule_shortcode' );

function peace_prayer_schedule_shortcode($atts, $content = null) {
	extract( shortcode_atts(
		array(
			'image'		=> '',
			'title'		=> '',
			'description'	=> '',
			'schedule_one_title' => '',
			'schedule_one_des'	=> '',
			'schedule_one_date'		=> '',
			'schedule_one_time'		=> '',
			'schedule_two_title' => '',
			'schedule_two_des'	=> '',
			'schedule_two_date'		=> '',
			'schedule_two_time'		=> '',
			'schedule_three_title' => '',
			'schedule_three_des'	=> '',
			'schedule_three_date'		=> '',
			'schedule_three_time'		=> '',
			'schedule_four_title' => '',
			'schedule_four_des'	=> '',
			'schedule_four_date'		=> '',
			'schedule_four_time'		=> '',
			'schedule_five_title' => '',
			'schedule_five_des'	=> '',
			'schedule_five_date'		=> '',
			'schedule_five_time'		=> '',
			'schedule_six_title' => '',
			'schedule_six_des'	=> '',
			'schedule_six_min'		=> '',
			'schedule_six_time'		=> '',
			'schedule_sunrise'	=>'',
			'schedule_sunset'	=>'',
			
			), $atts )
	);
	ob_start();
	$image = peace_vc_image($image);
	?>
	<section class="shedule section-padding" style="background: url(<?php echo esc_url($image ); ?>);">
		<div class="container">
			<div class="row">

				<div class="col-md-4 <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.6s">
					<h2 class="section-title"><?php echo esc_html($title) ?></h2><!-- /.section-title -->
					<div class="section-detail"><?php echo wp_kses_post($description) ?></div>
				</div>

				<div class="col-md-8">
					
				
				<div class="shedule-list col-md-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.4s">
					<div class="shedule-time shedule-before col-md-6 col-xs-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_one_title)) { echo esc_html($schedule_one_title); } else { echo "Fajr"; } ?></h3>
							<span><?php if(!empty($schedule_one_des)) { echo esc_html($schedule_one_des); } else { echo "5:00 AM"; } ?></span>
						</div>

						<div class="clock schedule-time col-xs-5" data-time="<?php if(!empty($schedule_one_time)) { echo esc_attr($schedule_one_time); } else {echo "04:30:00"; } ?>">

						</div>
					</div>
					<div class="shedule-time col-md-6 col-xs-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_two_title)) { echo esc_html($schedule_two_title); } else { echo "Dhuhr"; } ?></h3>
							<span><?php if(!empty($schedule_two_des)) { echo esc_html($schedule_two_des); } else { echo "1:30 PM "; } ?></span>
						</div>

						<div class="clock schedule-time col-xs-5" data-time="<?php if(!empty($schedule_two_time)) { echo esc_attr($schedule_two_time); } else {echo "13:00:00"; } ?>">

						</div>
					</div>
					<div class="shedule-time shedule-before col-md-6 col-xs-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_three_title)) { echo esc_html($schedule_three_title); } else { echo "Asr"; } ?></h3>
							<span><?php if(!empty($schedule_three_des)) { echo esc_html($schedule_three_des); } else { echo "4:30 PM"; } ?></span>
						</div>

						<div class="clock schedule-time col-xs-5"  data-time="<?php if(!empty($schedule_three_time)) { echo esc_attr($schedule_three_time); } else {echo "17:00:00"; } ?>">

						</div>
					</div>
					<div class="shedule-time col-md-6 col-xs-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_four_title)) { echo esc_html($schedule_four_title); } else { echo "Maghrib"; } ?></h3>
							<span><?php if(!empty($schedule_four_des)) { echo esc_html($schedule_four_des); } else { echo "6:30 PM"; } ?></span>
						</div>

						<div class="clock schedule-time col-xs-5"  data-time="<?php if(!empty($schedule_four_time)) { echo esc_attr($schedule_four_time); } else {echo "18:30:00"; } ?>">

						</div>
					</div>
					<div class="shedule-time shedule-before shedule-after col-md-6 col-xs-12 no-margin <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_five_title)) { echo esc_html($schedule_five_title); } else { echo "Isha"; } ?></h3>
							<span><?php if(!empty($schedule_five_des)) { echo esc_html($schedule_five_des); } else { echo "8:00 PM"; } ?></span>
						</div>

						<div class="clock schedule-time col-xs-5" data-time="<?php if(!empty($schedule_five_time)) { echo esc_attr($schedule_five_time); } else {echo "20:30:00"; } ?>">

						</div>
					</div>
					<div class="shedule-time shedule-after col-md-6 col-xs-12 no-margin responsive-fix <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_six_title)) { echo esc_html($schedule_six_title); } else { echo "Jummah"; } ?></h3>
							<span><?php if(!empty($schedule_six_des)) { echo esc_html($schedule_six_des); } else { echo "12:30 PM"; } ?></span>
						</div>

						<div class="jummah schedule-time col-xs-5" data-time="<?php if(!empty($schedule_six_time)) { echo esc_attr($schedule_six_time); } else {echo "12:30:00"; } ?>">
						</div>
					</div><!-- /.shedule-list -->
					
				</div>
				<div class="sunrise col-md-6 <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.6s">
						<div class="col-md-5">
							<img src="<?php echo get_template_directory_uri(); ?>/images/sun.png" alt="sunrise">
						</div>	
						<div class="col-md-7">
							<h2><?php echo esc_html_e('SUNRISE', 'peace');?></h2>
							<span><?php echo esc_html($schedule_sunrise) ?></span>
						</div>
					</div>
					<div class="sunrise sunset col-md-6 <?php echo wow_effect(); ?> fadeInRight" data-wow-delay="0.6s">
						<div class="col-md-5">
							<img src="<?php echo get_template_directory_uri(); ?>/images/sun2.png" alt="sunset">
						</div>
						<div class="col-md-7">
							<h2><?php echo esc_html_e('SUNSET', 'peace') ?></h2>
							<span><?php echo esc_html($schedule_sunset) ?></span>
						</div>
					</div>
				</div>
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section>

	<script>
		jQuery( document ).ready(function() {



			jQuery('.clock').each( function() {
			//22
			var time = jQuery(this).data('time');
			var i = jQuery(this);
			var init = makeCounter(time, i);

		});
			function makeCounter(time, i) {

				var nextDay = "<?php echo date('Y/m/j', strtotime('+ 1 day')); ?> ";

				var currentTime = nextDay + time;
				jQuery(i).countdown(currentTime, function(event) {
					var $this = jQuery(this).html(event.strftime(''
						+'<div class="hour col-xs-6"><h3>%H</h3> <span>Hours</span></div>' 
						+ '<div class="hour min col-xs-6"><h3>%M</h3> <span>Min.</span></div>'
						));
				}).on('finish.countdown', makeCounter);
			}


			jQuery('.jummah').each( function() {
			//22
			var time = jQuery(this).data('time');
			var i = jQuery(this);
			var init = jummahmakeCounter(time, i);
		});
			function jummahmakeCounter(time, i) {

				var nextDay = "<?php echo date('Y/m/j', strtotime('next friday')); ?> ";

				var currentTime = nextDay + time;
				jQuery(i).countdown(currentTime, function(event) {
					var $this = jQuery(this).html(event.strftime(''
						+'<div class="hour col-xs-6"><h3>%d</h3> <span>Days</span></div>' 
						+ '<div class="hour min col-xs-6"><h3>%H</h3> <span>Hours</span></div>'
						));
				}).on('finish.countdown', jummahmakeCounter);
			}

		});
</script>
<?php
return ob_get_clean();
}

/*------------------------------------------------------------------------------------------------------------------*/
/*	prayer shedule other religion 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_prayer_schedule_other', 'peace_prayer_schedule_other_shortcode' );

function peace_prayer_schedule_other_shortcode($atts, $content = null) {
	extract( shortcode_atts(
		array(
			'image'		=> '',
			'title'		=> '',
			'description'	=> '',
			'schedule_one_title' => '',
			'schedule_one_des'	=> '',
			'schedule_one_date'		=> '',
			'schedule_one_time'		=> '',
			'schedule_two_title' => '',
			'schedule_two_des'	=> '',
			'schedule_two_date'		=> '',
			'schedule_two_time'		=> '',
			'schedule_three_title' => '',
			'schedule_three_des'	=> '',
			'schedule_three_date'		=> '',
			'schedule_three_time'		=> '',
			'schedule_four_title' => '',
			'schedule_four_des'	=> '',
			'schedule_four_date'		=> '',
			'schedule_four_time'		=> '',
			'schedule_five_title' => '',
			'schedule_five_des'	=> '',
			'schedule_five_date'		=> '',
			'schedule_five_time'		=> '',
			'schedule_six_title' => '',
			'schedule_six_des'	=> '',
			'schedule_six_date'		=> '',
			'schedule_six_time'		=> '',
			'schedule_sunrise'	=>'',
			'schedule_sunset'	=>'',
			
			), $atts )
	);
	ob_start();
	$image = peace_vc_image($image);
	?>
	<section class="shedule section-padding" style="background: url(<?php echo esc_url($image ); ?>);">
		<div class="container">
			<div class="row">

				<div class="col-md-4 <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.6s">
					<h2 class="section-title"><?php echo esc_html($title) ?></h2><!-- /.section-title -->
					<div class="section-detail"><?php echo wp_kses_post($description) ?></div>
				</div>

				<div class="col-md-8">
					
				
				<div class="shedule-list col-md-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
					<div class="shedule-time shedule-before col-md-6 col-xs-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_one_title)) { echo esc_html($schedule_one_title); } else { echo "Fajr"; } ?></h3>
							<span><?php if(!empty($schedule_one_des)) { echo esc_html($schedule_one_des); } else { echo "5:00 AM"; } ?></span>
						</div>

						<div class="clock_counter schedule-time col-xs-5" data-time="<?php if(!empty($schedule_one_time)) { echo esc_attr($schedule_one_time); } else {echo "04:30:00"; } ?>">

						</div>
					</div>
					<div class="shedule-time col-md-6 col-xs-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_two_title)) { echo esc_html($schedule_two_title); } else { echo "Dhuhr"; } ?></h3>
							<span><?php if(!empty($schedule_two_des)) { echo esc_html($schedule_two_des); } else { echo "1:30 PM "; } ?></span>
						</div>

						<div class="clock_counter schedule-time col-xs-5" data-time="<?php if(!empty($schedule_two_time)) { echo esc_attr($schedule_two_time); } else {echo "13:00:00"; } ?>">

						</div>
					</div>
					<div class="shedule-time shedule-before col-md-6 col-xs-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_three_title)) { echo esc_html($schedule_three_title); } else { echo "Asr"; } ?></h3>
							<span><?php if(!empty($schedule_three_des)) { echo esc_html($schedule_three_des); } else { echo "4:30 PM"; } ?></span>
						</div>

						<div class="clock_counter schedule-time col-xs-5"  data-time="<?php if(!empty($schedule_three_time)) { echo esc_attr($schedule_three_time); } else {echo "17:00:00"; } ?>">

						</div>
					</div>
					<div class="shedule-time col-md-6 col-xs-12 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_four_title)) { echo esc_html($schedule_four_title); } else { echo "Maghrib"; } ?></h3>
							<span><?php if(!empty($schedule_four_des)) { echo esc_html($schedule_four_des); } else { echo "6:30 PM"; } ?></span>
						</div>

						<div class="clock_counter schedule-time col-xs-5"  data-time="<?php if(!empty($schedule_four_time)) { echo esc_attr($schedule_four_time); } else {echo "18:30:00"; } ?>">

						</div>
					</div>
					<div class="shedule-time shedule-before shedule-after col-md-6 col-xs-12 no-margin <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_five_title)) { echo esc_html($schedule_five_title); } else { echo "Isha"; } ?></h3>
							<span><?php if(!empty($schedule_five_des)) { echo esc_html($schedule_five_des); } else { echo "8:00 PM"; } ?></span>
						</div>

						<div class="clock_counter schedule-time col-xs-5" data-time="<?php if(!empty($schedule_five_time)) { echo esc_attr($schedule_five_time); } else {echo "20:30:00"; } ?>">

						</div>
					</div>
					<div class="shedule-time shedule-after col-md-6 col-xs-12 no-margin responsive-fix <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
						<div class="schedule-name col-xs-7">
							<h3><?php if(!empty($schedule_six_title)) { echo esc_html($schedule_six_title); } else { echo "Jummah"; } ?></h3>
							<span><?php if(!empty($schedule_six_des)) { echo esc_html($schedule_six_des); } else { echo "12:30 PM"; } ?></span>
						</div>

						<div class="clock_counter schedule-time col-xs-5" data-time="<?php if(!empty($schedule_six_time)) { echo esc_attr($schedule_six_time); } else {echo "12:30:00"; } ?>">
						</div>
					</div><!-- /.shedule-list -->
					
				</div>
				<div class="sunrise col-md-6 <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.6s">
						<div class="col-md-5">
							<img src="<?php echo get_template_directory_uri(); ?>/images/sun.png" alt="sunrise">
						</div>	
						<div class="col-md-7">
							<h2><?php echo esc_html_e('SUNRISE', 'peace');?></h2>
							<span><?php echo esc_html($schedule_sunrise) ?></span>
						</div>
					</div>
					<div class="sunrise sunset col-md-6 <?php echo wow_effect(); ?> fadeInRight" data-wow-delay="0.6s">
						<div class="col-md-5">
							<img src="<?php echo get_template_directory_uri(); ?>/images/sun2.png" alt="sunset">
						</div>
						<div class="col-md-7">
							<h2><?php echo esc_html_e('SUNSET', 'peace') ?></h2>
							<span><?php echo esc_html($schedule_sunset) ?></span>
						</div>
					</div>
					</div>
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section>

<script>
	jQuery( document ).ready(function() {



		jQuery('.clock_counter').each( function() {
			//22
			var time = jQuery(this).data('time');
			var date = jQuery(this).data('date');
			var i = jQuery(this);
			var init = othermakeCounter(time, date, i);
		});
		function othermakeCounter(time, date, i) {

			var nextDay = "<?php echo date('Y/m/j', strtotime('+ 1 day')); ?> ";
			if(date>nextDay) { 
				greeting = date; 
			} else { 
				greeting = nextDay; 
			}


			var currentTime = greeting + time;
			jQuery(i).countdown(currentTime, function(event) {
				var $this = jQuery(this).html(event.strftime(''
					+'<div class="hour col-xs-6"><h3>%d</h3> <span>Day</span></div>' 
					+ '<div class="hour min col-xs-6"><h3>%H</h3> <span>Hours</span></div>'
					));
			}).on('finish.countdown', othermakeCounter);
		}
		
	});
</script>
<?php
return ob_get_clean();
}


/*------------------------------------------------------------------------------------------------------------------*/
/*	service section 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_service', 'peace_service_section' );

function peace_service_section($atts, $content = null){
	extract( shortcode_atts(
		array(
			'title'				=> '',
			'service_one'		=> '',
			'service_one_icon'	=> '',
			'service_one_des'	=> '',
			'service_two'		=> '',
			'service_two_icon'	=> '',
			'service_two_des'	=> '',
			'service_three'		=> '',
			'service_three_icon'=> '',
			'service_three_des'	=> '',
			'service_four'		=> '',
			'service_four_icon'	=> '',
			'service_four_des'	=> '',
			'service_five'		=> '',
			'service_five_icon'	=> '',
			'service_five_des'	=> '',
			'service_six'		=> '',
			'service_six_icon'	=> '',
			'service_six_des'	=> '',
			), $atts )
	);
	ob_start();

	?>
	<div class="service">
		<div class="col-md-3 service-details">
			<div class="pooja pooja1 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
				<div class="head"><?php echo esc_html($service_one); ?></div>
				<div class="contenet">
					<?php echo esc_html($service_one_des); ?>
				</div>
			</div>
			<div class="pooja pooja2 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
				<div class="head"><?php echo esc_html($service_two); ?></div>
				<div class="contenet">
					<?php echo esc_html($service_two_des); ?>
				</div>
			</div>
			<div class="pooja pooja3 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
				<div class="head"><?php echo esc_html($service_three); ?></div>
				<div class="contenet">
					<?php echo esc_html($service_three_des); ?>
				</div>
			</div>
		</div>

		<div class="col-md-6">
			<div class="provide <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
				<div class="circle <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
					<span><div class="text"><?php echo wp_kses_post($title ); ?></div></span>
				</div>
				<div class="col-5">
					<div class="item hand <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="1.0s">
						<div class="item-element">
							<span class="<?php echo esc_html($service_one_icon); ?>"></span>
						</div>
					</div>
				</div><!-- /.col-md-3 -->
				<div class="col-5">
					<div class="item hand1 <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="1.2s">
						<div class="item-element">
							<span class="<?php echo esc_html($service_two_icon); ?>"></span>
						</div>
					</div>
				</div><!-- /.col-md-3 -->
				<div class="col-5">
					<div class="item hand2 <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="1.4s">
						<div class="item-element">
							<span class="<?php echo esc_html($service_three_icon); ?>"></span>
						</div>
					</div>
				</div><!-- /.col-md-3 -->
				<div class="col-5">
					<div class="item hand3">
						<div class="item-element">
							<span class="<?php echo esc_html($service_four_icon); ?>"></span>
						</div>
					</div>
				</div><!-- /.col-md-3 -->
				<div class="col-5">
					<div class="item hand4">
						<div class="item-element">
							<span class="<?php echo esc_html($service_five_icon); ?>"></span>
						</div>
					</div>
				</div><!-- /.col-md-3 -->
				<div class="col-5">
					<div class="item hand5">
						<div class="item-element">
							<span class="<?php echo esc_html($service_six_icon); ?>"></span>
						</div>
					</div>
				</div><!-- /.col-md-3 -->
			</div>
		</div>
		<div class="col-md-3 service-details">
			<div class="darson darson1 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
				<div class="head"><?php echo esc_html($service_four); ?></div>
				<div class="contenet">
					<?php echo esc_html($service_four_des); ?>
				</div>
			</div>
			<div class="darson darson2 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
				<div class="head"><?php echo esc_html($service_five); ?></div>
				<div class="contenet">
					<?php echo esc_html($service_five_des); ?>
				</div>
			</div>
			<div class="darson darson3 <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.6s">
				<div class="head"><?php echo esc_html($service_six); ?></div>
				<div class="contenet">
					<?php echo esc_html($service_six_des); ?>
				</div>
			</div>
		</div>

	</div>
	<script>
	<?php 
$theme_color = cs_get_customize_option('theme_color_picker');
	 ?>
		jQuery(document).ready(function(){
			jQuery(".service .service-details .pooja1").hover(function(){
				jQuery(".service .hand .item-element").css('background-color', '<?php if(!empty($theme_color)) { echo $theme_color; } else { echo "#f1c152"; } ?>');
			}, function() {
    			// on mouseout, reset the background colour
    			jQuery('.service .hand .item-element').css('background-color', '');
    		});

    		jQuery(".service .service-details .pooja2").hover(function(){
				jQuery(".service .hand2 .item-element").css('background-color', '<?php if(!empty($theme_color)) { echo $theme_color; } else { echo "#f1c152"; } ?>');
			}, function() {
    			// on mouseout, reset the background colour
    			jQuery('.service .hand2 .item-element').css('background-color', '');
    		});

    		jQuery(".service .service-details .pooja3").hover(function(){
				jQuery(".service .hand4 .item-element").css('background-color', '<?php if(!empty($theme_color)) { echo $theme_color; } else { echo "#f1c152"; } ?>');
			}, function() {
    			// on mouseout, reset the background colour
    			jQuery('.service .hand4 .item-element').css('background-color', '');
    		});

    		jQuery(".service .service-details .darson1").hover(function(){
				jQuery(".service .hand1 .item-element").css('background-color', '<?php if(!empty($theme_color)) { echo $theme_color; } else { echo "#f1c152"; } ?>');
			}, function() {
    			// on mouseout, reset the background colour
    			jQuery('.service .hand1 .item-element').css('background-color', '');
    		});

    		jQuery(".service .service-details .darson2").hover(function(){
				jQuery(".service .hand3 .item-element").css('background-color', '<?php if(!empty($theme_color)) { echo $theme_color; } else { echo "#f1c152"; } ?>');
			}, function() {
    			// on mouseout, reset the background colour
    			jQuery('.service .hand3 .item-element').css('background-color', '');
    		});

    		jQuery(".service .service-details .darson3").hover(function(){
				jQuery(".service .hand5 .item-element").css('background-color', '<?php if(!empty($theme_color)) { echo $theme_color; } else { echo "#f1c152"; } ?>');
			}, function() {
    			// on mouseout, reset the background colour
    			jQuery('.service .hand5 .item-element').css('background-color', '');
    		});
		});
	</script>
	<?php
	return ob_get_clean();
}

/*------------------------------------------------------------------------------------------------------------------*/
/*	what we do 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_about_us', 'peace_what_we_do_shortcode' );

function peace_what_we_do_shortcode($atts, $content = null) {
	extract( shortcode_atts(
		array(
			'about_section_title'	=> '',
			'about_section_desc'	=>'',
			'about_one_title'	=>'',
			'about_one_icon'	=> '',
			'about_one_des'		=> '',
			'about_two_title'	=>'',
			'about_two_icon'	=> '',
			'about_two_des'	=> '',
			'about_three_title'	=>'',
			'about_three_icon'		=> '',
			'about_three_des'	=> '',
			), $atts )
	);
	ob_start();
	?>
	<div class="what-we-do about-us">
		
		
		<h2 class="section-title <?php echo wow_effect(); ?> fadeInDown" data-wow-delay="0.6s"><?php echo esc_html($about_section_title) ?></h2><!-- /.section-title -->
		<div class="section-detail <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.6s"><?php echo wp_kses_post($about_section_desc) ?></div>

		<div class="service-details">
			
			<div class="darson <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.6s">
				<div class="item">
					<div class="item-element">
						<span class="<?php echo esc_attr($about_one_icon); ?>"></span>
					</div>
				</div>
				<div class="head"><?php echo esc_attr($about_one_title); ?></div>
				<div class="content">
					<?php echo esc_attr($about_one_des); ?>
				</div>
			</div>
			<div class="darson <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.6s">
				<div class="item">
					<div class="item-element">
						<span class="<?php echo esc_attr($about_two_icon); ?>"></span>
					</div>
				</div>
				<div class="head"><?php echo esc_attr($about_two_title); ?></div>
				<div class="content">
					<?php echo esc_attr($about_two_des); ?>
				</div>
			</div>
			<div class="darson <?php echo wow_effect(); ?> fadeInLeft" data-wow-delay="0.6s">
				<div class="item">
					<div class="item-element">
						<span class="<?php echo esc_attr($about_three_icon); ?>"></span>
					</div>
				</div>
				<div class="head"><?php echo esc_attr($about_three_title); ?></div>
				<div class="content">
					<?php echo esc_attr($about_three_des); ?>
				</div>
			</div>

		</div>
	</div>

	<?php
	return ob_get_clean();
}

/*------------------------------------------------------------------------------------------------------------------*/
/*	about a person 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_person', 'peace_person_shortcode' );

function peace_person_shortcode($atts, $content = null) {
	extract( shortcode_atts(
		array(
			'name'				=> '',
			'image'				=> '',
			'designation'		=> '',
			'short_des'	=> '',
			'fb'		=> '',
			'tw'	=> '',
			'lnd'	=> '',
			), $atts )
	);
	ob_start();
	$image = peace_vc_image($image);
	?>
	<div class="about-us <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.4s">
		<div class="service-person">
			<img src="<?php echo esc_url($image ); ?>" alt="<?php esc_attr($name) ?>">
			<div class="person-details">
				<h1><?php echo esc_html($name) ?></h1>
				<span><?php echo esc_html($designation) ?></span>
				<div class="person-content">
					<?php echo esc_html($short_des) ?>
				</div>
				<div class="person-social">
					<ul>
						<li><a href="<?php echo esc_url($fb) ?>"><i class="fa fa-facebook"></i></a></li>
						<li><a href="<?php echo esc_url($tw) ?>"><i class="fa fa-twitter"></i></a></li>
						<li><a href="<?php echo esc_url($lnd) ?>"><i class="fa fa-linkedin"></i></a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>

	<?php
	return ob_get_clean();
}


/*-----------------------------------------------------------------------------------*/
/*	simple feature image slider 
/*-----------------------------------------------------------------------------------*/ 

add_shortcode('peace_testimonial', 'peace_testimonial_shortcode' );

function peace_testimonial_shortcode($atts, $content = null) {

	$html = $image_one = $image_two = $image_three = $image_one_title = $image_two_title= $image_three_title = $image_one_url = $image_two_url = $image_three_url = '';
	extract( shortcode_atts(
		array(
			'image_one' 		=> '',
			'image_one_testimonial' 	=> '',
			'image_one_name' 	=> '',
			'image_two' 		=> '',
			'image_two_testimonial' 	=> '',
			'image_two_name' 	=> '',
			'image_three'		=> '',
			'image_three_testimonial'	=> '',
			'image_three_name'		=> '',
			), $atts )
	);
	$image_one = peace_vc_image($image_one);
	$image_two = peace_vc_image($image_two);
	$image_three = peace_vc_image($image_three);

	$html .='

	<div id="peace-testimonial" class="product-carousel carousel slide" data-ride="carousel">
		
		<!-- Indicators -->
		<ol class="product-carousel-indicators carousel-indicators">
			<li data-target="#peace-testimonial" data-slide-to="0" class="active"></li>
			<li data-target="#peace-testimonial" data-slide-to="1" class=""></li>
			<li data-target="#peace-testimonial" data-slide-to="2" class=""></li>
		</ol>';

		$html .='<!-- Wrapper for slides -->
		<div class="carousel-inner col-md-8 centered" role="listbox">
			<div class="item active">
				<p>'.$image_one_testimonial.'</p>

				<div class="item-desc">
					<img src="'.$image_one.'" alt="'.$image_one_name.'">
					<h5>'.$image_one_name.'</a></h5> 
				</div>
			</div>
			<div class="item">
				<p>'.$image_two_testimonial.'</p>

				<div class="item-desc">
					<img src="'.$image_two.'" alt="'.$image_two_name.'">
					<h5>'.$image_two_name.'</a></h5> 
				</div>
			</div>
			<div class="item">
				<p>'.$image_three_testimonial.'</p>

				<div class="item-desc">
					<img src="'.$image_three.'" alt="'.$image_three_name.'">
					<h5>'.$image_three_name.'</a></h5> 
				</div>
			</div>

		</div>

	</div>';

	return $html;


}



/*-----------------------------------------------------------------------------------*/
/*	simple feature image slider 
/*-----------------------------------------------------------------------------------*/ 

add_shortcode('simple_carousel_shortcode', 'peace_simple_carousel_shortcode' );

function peace_simple_carousel_shortcode($atts, $content = null) {

	$html = $image_one = $image_two = $image_three = $image_one_title = $image_two_title= $image_three_title = $image_one_url = $image_two_url = $image_three_url = '';
	extract( shortcode_atts(
		array(
			'title'				=> '',
			'image_one' 		=> '',
			'image_one_title' 	=> '',
			'image_one_url' 	=> '',
			'image_two' 		=> '',
			'image_two_title' 	=> '',
			'image_one_url' 	=> '',
			'image_three'		=> '',
			'image_three_title'	=> '',
			'image_one_url'		=> '',
			), $atts )
	);
	$image_one = peace_vc_image($image_one);
	$image_two = peace_vc_image($image_two);
	$image_three = peace_vc_image($image_three);

	$html .='

	<h2 class="widget-title">'.$title.'</h2>
	<div id="menu-item-slider" class="product-carousel carousel slide" data-ride="carousel">
		
		<!-- Indicators -->
		<ol class="product-carousel-indicators carousel-indicators">
			<li data-target="#menu-item-slider" data-slide-to="0" class="active"></li>
			<li data-target="#menu-item-slider" data-slide-to="1" class=""></li>
			<li data-target="#menu-item-slider" data-slide-to="2" class=""></li>
		</ol>';

		$html .='<!-- Wrapper for slides -->
		<div class="carousel-inner" role="listbox">
			<div class="item active">
				<a href="'.$image_one_url.'" title="'.$image_one_title.'"><img src="  '.$image_one.' " alt="'.$image_one_title.'"></a> 
				<div class="item-caption">
					<h5><a href="'.$image_one_url.'" title="'.$image_one_title.'">'.$image_one_title.'</a></h5> 
				</div>
			</div>
			<div class="item">
				<a href="'.$image_two_url.'" title="'.$image_two_title.'"><img src=" '.$image_two.' " alt="'.$image_two_title.'"></a>
				<div class="item-caption">
					<h5><a href="'.$image_two_url.'" title="'.$image_two_title.'">'.$image_two_title.'</a></h5> 
				</div>
			</div>
			<div class="item">
				<a href="'.$image_three_url.'" title="'.$image_three_title.'"><img src=" '.$image_three.'" alt="'.$image_three_title.'"></a>
				<div class="item-caption">
					<h5><a href="'.$image_three_url.'" title="'.$image_three_title.'">'.$image_three_title.'</a></h5> 
				</div>
			</div>

		</div>

	</div>';

	return $html;


}


/*------------------------------------------------------------------------------------------------------------------*/
/*	woocommerce product slide 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_woo_product_slider', 'peace_woo_product_slider_shortcode' );

function peace_woo_product_slider_shortcode($atts, $content = null) {

	extract( shortcode_atts(
		array(
			'title'				=> '',
			'product_category'	=> '',
			), $atts )
	);
	ob_start();
	?>

	
	<div id="menu-product-slider" class="menu-product-slider product-carousel carousel slide <?php echo wow_effect(); ?> fadeInUp" data-wow-delay="0.4s" data-ride="carousel">
		<h2 class="widget-title"><?php echo esc_html($title) ?></h2>
		<!-- Indicators -->
		<ol class="product-carousel-indicators carousel-indicators">
			<li data-target="#menu-product-slider" data-slide-to="0" class="active"></li>
			<li data-target="#menu-product-slider" data-slide-to="1" class=""></li>
			<li data-target="#menu-product-slider" data-slide-to="2" class=""></li>
		</ol>

		<div class="woocommerce  carousel-inner" role="listbox">
			<?php
			$i = 0;
			query_posts('post_type=product&posts_per_page=3&product_cat='. $product_category ); ?>
			<?php if(have_posts()) : while(have_posts()) : the_post(); 
			global $post;
			?>
			<div class="item <?php echo !$i ? 'active' : ''; ?>">


				<div class="product-item clearfix">
					<div class="product-image">
						<?php if(has_post_thumbnail()) { ?>
						<a class="thumb" href="<?php the_permalink(); ?>">

							<?php
									/**
									 * woocommerce_before_shop_loop_item_title hook
									 *
									 * @hooked woocommerce_show_product_loop_sale_flash - 10
									 * @hooked woocommerce_template_loop_product_thumbnail - 10
									 */
									do_action( 'woocommerce_before_shop_loop_item_title' );

									?>
								</a>
								<?php }else {
									echo '<img src="'.get_template_directory_uri(). '/assets/images/no-img-team.jpg" alt="">';
								} ?>
								<?php 
								$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'large' );

								?>
								<a href="<?php  echo $image[0]; ?>" class="quick-view boxer" title="<?php the_title(); ?>"><span>Quick View</span></a>
							</div>

							<div class="product-description product-slide">
								<div class="product-head">
									<h2 class="product-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
									<?php
										/**
										 * woocommerce_after_shop_loop_item_title hook
										 *
										 * @hooked woocommerce_template_loop_rating - 5
										 * @hooked woocommerce_template_loop_price - 10
										 */
										do_action( 'woocommerce_after_shop_loop_item_title' );

										?>

									</div>
									<div class="product-action">

										<?php

										/**
										 * woocommerce_after_shop_loop_item hook
										 *
										 * @hooked woocommerce_template_loop_add_to_cart - 10
										 */
										do_action( 'woocommerce_after_shop_loop_item' ); 

										?>
									</div>
								</div>
							</div>

						</div>
						<?php 
						$i = 1;
						endwhile;endif; wp_reset_query(); ?>


					</div>

				</div>

				<?php
				return ob_get_clean();
			}

/*------------------------------------------------------------------------------------------------------------------*/
/*	simple separator 
/*------------------------------------------------------------------------------------------------------------------*/ 

add_shortcode('peace_separator', 'peace_separator_shortcode' );

function peace_separator_shortcode($atts, $content = null) {

	extract( shortcode_atts(
		array(
			's_width'				=> '',
			's_height'	=> '',
			'color_pic'	=> '',
			), $atts )
	);
	ob_start();
	?>

	<div class="col-md-1 hidden-sm hidden-xs">
		<div class="peace-separator" style="width: <?php echo esc_attr($s_width); ?>;height: <?php echo esc_attr($s_height); ?>;background-color: <?php echo esc_attr($color_pic); ?>;"></div>
	</div>

	<?php
	return ob_get_clean();
}