<?php 
/*
Plugin Name: Peace Required Plugin
Plugin URI: http://codexcoder.com
Description: After install the peace WordPress Theme, you must need to install this "Peace Required Plugin" first to get all features of Peace WP Theme.
Author: Jahirul Islam Mamun- CodexCoder
Author URI: http://www.CodexCoder.com
Version: 1.0.1
Text Domain: peace
*/

//define
define( 'PLG_URL', plugins_url() );
define( 'PLG_DIR', dirname( __FILE__ ) ); 


/*-----------------------------------------------------------------------------------*/
/*	peace vc shortcode 
/*-----------------------------------------------------------------------------------*/ 

include_once(PLG_DIR. '/shortcode-action.php');


/*-----------------------------------------------------------------------------------*/
/*	feature custom post type
/*-----------------------------------------------------------------------------------*/ 

add_action( 'init', 'peace_custom_post'  );

/* Create Portfolio, Testimonial, Slider and Clients post type */
if (!function_exists('peace_custom_post')) {

	function peace_custom_post() {

		
		$labels = array(
			'name' => __( "Gallery", 'peace' ),
			'singular_name' => __( "Gallery", 'peace' ),
			'add_new_item' => __( "Add New Gallery Package", 'peace' ),
			'edit_item' => __( "Edit Gallery Package", 'peace' ),
			'new_item' => __( "New Gallery Package", 'peace' ),
			'view_item' => __( "View Gallery", 'peace' ),
			'search_items' => __( "Search Gallery", 'peace' ),
			'not_found' => __( "No Gallery Found", 'peace' ),
			'not_found_in_trash' => __( "No Gallery Found in Trash", 'peace' ),
			'parent_item_colon' => __( "Parent Gallery", 'peace' ),
			'menu_name' => __( "Gallery", 'peace' )
			);

		$args = array(
			'labels' => $labels,
			'heirarchical' => false,
			'descriptin' => 'View Gallery',
			'supports'  => array('title'),
			'public' => true,
			'show_ui' => true,
			'menu_icon'           => 'dashicons-images-alt',
			'show_in_menu' => true,
			'show_in_nav_menu' => true,
			'publicly_queryable' => true,
			'exclude_from_search' => false,
			'has_archive' => true,
			'query_var' => true,
			'can_export' => true,
			'rewrite' => true,
			'supports'	=> array('title', 'editor', 'thumbnail'),
			'capability_type' => 'post'
			);

		register_post_type( 'gallery', $args );



	/**  category.
	--------------------------------------------------------------------------------------------------- */
	$labels = array(
		'name'					=> __( 'Categories', 'Taxonomy plural name', 'peace' ),
		'singular_name'			=> __( 'Category', 'Taxonomy singular name', 'peace' ),
		'search_items'			=> __( 'Search Categories', 'peace' ),
		'popular_items'			=> __( 'Popular Categories', 'peace' ),
		'all_items'				=> __( 'All Categories', 'peace' ),
		'parent_item'			=> __( 'Parent Category', 'peace' ),
		'parent_item_colon'		=> __( 'Parent Category', 'peace' ),
		'edit_item'				=> __( 'Edit Category', 'peace' ),
		'update_item'			=> __( 'Update Category', 'peace' ),
		'add_new_item'			=> __( 'Add New Image Category', 'peace' ),
		'new_item_name'			=> __( 'New Category Name', 'peace' ),
		'add_or_remove_items'	=> __( 'Add or remove Categories', 'peace' ),
		'choose_from_most_used'	=> __( 'Choose from most used peace', 'peace' ),
		'menu_name'				=> __( 'Categories', 'peace' ),
		);

	$args = array(
		'labels'            => $labels,
		'public'            => true,
		'show_in_nav_menus' => true,
		'show_admin_column' => false,
		'hierarchical'      => true,
		'show_tagcloud'     => true,
		'show_ui'           => true,
		'query_var'         => true,
		'rewrite'           => true,
		'query_var'         => true,
		'capabilities'      => array(),
		);

	register_taxonomy( 'image-category', array( 'gallery' ), $args );



	/*------------------------------------------------------------------------------------------------------------------*/
	/*	sermons custom post 
	/*------------------------------------------------------------------------------------------------------------------*/ 
	
	$labels = array(
			'name' => __( "Sermons", 'peace' ),
			'singular_name' => __( "Sermons", 'peace' ),
			'add_new_item' => __( "Add New Sermons", 'peace' ),
			'edit_item' => __( "Edit Sermons", 'peace' ),
			'new_item' => __( "New Sermons", 'peace' ),
			'view_item' => __( "View Sermons", 'peace' ),
			'search_items' => __( "Search Sermons", 'peace' ),
			'not_found' => __( "No Sermons Found", 'peace' ),
			'not_found_in_trash' => __( "No Sermons Found in Trash", 'peace' ),
			'parent_item_colon' => __( "Parent Sermons", 'peace' ),
			'menu_name' => __( "Sermons", 'peace' )
			);

		$args = array(
			'labels' => $labels,
			'heirarchical' => false,
			'descriptin' => 'View Sermons',
			'supports'  => array('title'),
			'public' => true,
			'show_ui' => true,
			'menu_icon'           => 'dashicons-video-alt',
			'show_in_menu' => true,
			'show_in_nav_menu' => true,
			'publicly_queryable' => true,
			'exclude_from_search' => false,
			'has_archive' => true,
			'query_var' => true,
			'can_export' => true,
			'rewrite' => true,
			'supports'	=> array('title', 'editor', 'thumbnail'),
			'capability_type' => 'post'
			);

		register_post_type( 'sermons', $args ); 

		

/*------------------------------------------------------------------------------------------------------------------*/
/*	  causes post
/*------------------------------------------------------------------------------------------------------------------*/ 
	
$labels = array(
			'name' => __( "Causes", 'peace' ),
			'singular_name' => __( "Causes", 'peace' ),
			'add_new_item' => __( "Add New Causes", 'peace' ),
			'edit_item' => __( "Edit Causes", 'peace' ),
			'new_item' => __( "New Causes", 'peace' ),
			'view_item' => __( "View Causes", 'peace' ),
			'search_items' => __( "Search Causes", 'peace' ),
			'not_found' => __( "No Causes Found", 'peace' ),
			'not_found_in_trash' => __( "No Causes Found in Trash", 'peace' ),
			'parent_item_colon' => __( "Parent Causes", 'peace' ),
			'menu_name' => __( "Causes", 'peace' )
			);

		$args = array(
			'labels' => $labels,
			'heirarchical' => false,
			'descriptin' => 'View Causes',
			'supports'  => array('title'),
			'public' => true,
			'show_ui' => true,
			'menu_icon'           => 'dashicons-shield',
			'show_in_menu' => true,
			'show_in_nav_menu' => true,
			'publicly_queryable' => true,
			'exclude_from_search' => false,
			'has_archive' => true,
			'query_var' => true,
			'can_export' => true,
			'rewrite' => true,
			'supports'	=> array('title', 'editor', 'thumbnail'),
			'capability_type' => 'post'
			);

		register_post_type( 'causes', $args ); 	  	

	/*------------------------------------------------------------------------------------------------------------------*/
	/*	event custom post 
	/*------------------------------------------------------------------------------------------------------------------*/ 
	
	$labels = array(
			'name' => __( "Event", 'peace' ),
			'singular_name' => __( "Event", 'peace' ),
			'add_new_item' => __( "Add New Event", 'peace' ),
			'edit_item' => __( "Edit Event", 'peace' ),
			'new_item' => __( "New Event", 'peace' ),
			'view_item' => __( "View Event", 'peace' ),
			'search_items' => __( "Search Event", 'peace' ),
			'not_found' => __( "No Event Found", 'peace' ),
			'not_found_in_trash' => __( "No Event Found in Trash", 'peace' ),
			'parent_item_colon' => __( "Parent Event", 'peace' ),
			'menu_name' => __( "Events", 'peace' )
			);

		$args = array(
			'labels' => $labels,
			'heirarchical' => false,
			'descriptin' => 'View Event',
			'supports'  => array('title'),
			'public' => true,
			'show_ui' => true,
			'menu_icon'           => 'dashicons-feedback',
			'show_in_menu' => true,
			'show_in_nav_menu' => true,
			'publicly_queryable' => true,
			'exclude_from_search' => false,
			'has_archive' => true,
			'query_var' => true,
			'can_export' => true,
			'rewrite' => true,
			'supports'	=> array('title', 'editor', 'thumbnail'),
			'capability_type' => 'post'
			);

		register_post_type( 'events', $args ); 

		/** event  category.
	--------------------------------------------------------------------------------------------------- */
	$labels = array(
		'name'					=> __( 'Categories', 'Taxonomy plural name', 'peace' ),
		'singular_name'			=> __( 'Category', 'Taxonomy singular name', 'peace' ),
		'search_items'			=> __( 'Search Categories', 'peace' ),
		'popular_items'			=> __( 'Popular Categories', 'peace' ),
		'all_items'				=> __( 'All Categories', 'peace' ),
		'parent_item'			=> __( 'Parent Category', 'peace' ),
		'parent_item_colon'		=> __( 'Parent Category', 'peace' ),
		'edit_item'				=> __( 'Edit Category', 'peace' ),
		'update_item'			=> __( 'Update Category', 'peace' ),
		'add_new_item'			=> __( 'Add New Image Category', 'peace' ),
		'new_item_name'			=> __( 'New Category Name', 'peace' ),
		'add_or_remove_items'	=> __( 'Add or remove Categories', 'peace' ),
		'choose_from_most_used'	=> __( 'Choose from most used peace', 'peace' ),
		'menu_name'				=> __( 'Categories', 'peace' ),
		);

	$args = array(
		'labels'            => $labels,
		'public'            => true,
		'show_in_nav_menus' => true,
		'show_admin_column' => false,
		'hierarchical'      => true,
		'show_tagcloud'     => true,
		'show_ui'           => true,
		'query_var'         => true,
		'rewrite'           => true,
		'query_var'         => true,
		'capabilities'      => array(),
		);

	register_taxonomy( 'event-category', array( 'events' ), $args );

		/**  Schedule.
		--------------------------------------------------------------------------------------------------- */
		
	$labels = array(
			'name' => __( "Schedule", 'peace' ),
			'singular_name' => __( "Schedule", 'peace' ),
			'add_new_item' => __( "Add New Schedule", 'peace' ),
			'edit_item' => __( "Edit Schedule", 'peace' ),
			'new_item' => __( "New Schedule", 'peace' ),
			'view_item' => __( "View Schedule", 'peace' ),
			'search_items' => __( "Search Schedule", 'peace' ),
			'not_found' => __( "No Schedule Found", 'peace' ),
			'not_found_in_trash' => __( "No Schedule Found in Trash", 'peace' ),
			'parent_item_colon' => __( "Parent Schedule", 'peace' ),
			'menu_name' => __( "Schedules", 'peace' )
			);

		$args = array(
			'labels' => $labels,
			'heirarchical' => false,
			'descriptin' => 'View Schedule',
			'supports'  => array('title'),
			'public' => true,
			'show_ui' => true,
			'menu_icon'           => 'dashicons-calendar',
			'show_in_menu' => true,
			'show_in_nav_menu' => true,
			'publicly_queryable' => true,
			'exclude_from_search' => false,
			'has_archive' => true,
			'query_var' => true,
			'can_export' => true,
			'rewrite' => true,
			'supports'	=> array('title', 'editor', 'thumbnail'),
			'capability_type' => 'post'
			);

		register_post_type( 'schedule', $args ); 


	
}



}



?>